#include<windows.h>
#include<graphics.h>
#include<cmath>

// circ7

void home_in();

int SCREEN_W = 600;
int SCREEN_H = 400;

main(int argc, char*argv[])
{
   // Deklaration und Initialisierung des Grafiktreibers
    int graphdriver, graphmode;
    graphdriver = DETECT;
    initgraph(&graphdriver, &graphmode, "Draw_Sine"); // graphics.h kann keine Windowstitel setzen

    setbkcolor(0); // Hintergrundfarbe des Ausgabefensters schwarz
    cleardevice(); // Lschen des Ausgabefensters

    setcolor(15); // Textfarbe weiss (15)
    settextstyle(10, HORIZ_DIR, 2); // Fontsyle, Richtung und Grsse
    //outtextxy(20, 120, "Sinuskurve zeichnen: "); // Textausgabe

    home_in(); // Funktionsaufruf von draw_circle()

 return 0;
}

void home_in ()
{
    // the x, y position of the homing missile
    int x = SCREEN_W / 2;
    int y = SCREEN_H / 2;
    // the angle and length of the missile's velocity vector
    int angle = 0;
    int length = 1;
    int angle_stepsize =  1;
    // determines whether the missile has reached
    // the target and a new one should be chosen
    bool new_target = true;
    // angle to the target
    int target_angle;
    // position of the target
    int target_x;
    int target_y;

    while (!GetAsyncKeyState(VK_ESCAPE))
    {
        setbkcolor(0); // Hintergrundfarbe des Ausgabefensters schwarz
        cleardevice(); // Lschen des Ausgabefensters
        // choose new target randomly when needed
        if (new_target == true)
        {
            target_x = ((SCREEN_W + rand() % (2 * SCREEN_W)) / 4);
            target_y = ((SCREEN_H + rand() % (2 * SCREEN_H)) / 4);
            new_target = false;
        }

        // draw a pixel where the target is
        putpixel ((target_x), (target_y),15);

        // draw the missile
        // (actually a circle with a line representing the angle)
        setcolor(WHITE);
        circle (x, y, 20);
        line (x, y, x +  (9 * cos (angle)), y +  (9 * sin (angle)));

        // move the missile
        x = x + length * cos (angle);
        y = y + length * sin (angle);

        // if we are very close to the target, set a new target
        if (abs (x - target_x) + abs (y - target_y) < 10)
        {
             new_target = true;
        }

        // calculate the angle from the missile to the target
        target_angle = atan2 (target_y - y, target_x - x);

        // Determine whether we should turn left or right.
        // Note that itofix (128) represents half a circle.
        // We use & 0xFFFFFF as a trick to get an angle
        // between 0 and 256.
        if (((angle - target_angle) & 0xFFFFFF) < 128)
        {
            angle = (angle - angle_stepsize) & 0xFFFFFF;
        }
        else
        {
            angle = (angle + angle_stepsize) & 0xFFFFFF;
        }
        delay (20);
    }
}
